// level.h

void InitGame( int player1, int player2 );
Boolean InitCharacter( int player, int level );
void PrepareStageGraphics( int type );
void BeginRound( Boolean changeMusic );
void InitDifficulty( void );
void ChooseDifficulty( int player );
void SelectRandomLevel( void );
void IncrementLevel( void );
void TotalVictory( void );
void SharewareVictory( void );
void RegisteredVictory( void );
void InitStage( void );
void DrawStage( void );
void GameStartMenu( void );
void ShowGameOverScreen( void );

#define kOpponentResource 'Levl'

#define kGlows 2

#define kSharewareLevels 4
#define kSharewareSolitaireLevels 5
#define kLevels 12
#define kTutorialLevel 14

#define kEasyLevel   50
#define kMediumLevel 70
#define kHardLevel   90
#define kUltraLevel  110


typedef struct 
{
	short color;
	short time;
} Glow;

typedef struct
{
	short picture;
	short intellect;
	short zapStyle;
	short autoSetup[6];
	short speedNormal;
	short speedRush;
	short music;
	short dropSpeed;
	Glow  glow[kGlows];
	short hints;
}
Character, *CharacterPtr, **CharacterHandle;

enum
{
	kPlayerControl = 0,
	kAIControl,
	kNobodyControl,
	kAutoControl
};

extern Character character[2];
extern int level, players, credits, difficulty[2];
extern int difficultyTicks, backdropTicks, backdropFrame;


